/******************************************************************************
Note to Hz

  History
	Date       Version    Programmer         Comments
	16/2/03    1.0        Darrell Tam		Created
******************************************************************************/

#include "StdAfx.h"
#include "FreqToNote.h"
#include "misc_stuff.h"

static char *note_names[] = {"c","c#","d","d#","e","f","f#","g","g#","a","a#","b" };
static float log_2 = logf(2);
static float log_c0_hz = logf(A4_FREQ)-(4.0f+9.0f/12.0f)*logf(2);
static map<string,float> note_to_hz;

//------------------------------------------------------------------------------------------
static void fillNoteToHz()
{
	float n = 0.0f; // offset from C-0
	for(int octave = 0; octave < 20; octave++) {
		for(int note = 0; note < 12; note++) {
			ostringstream s;
			s << note_names[note] << octave;
			note_to_hz[s.str()] = powf(2.0f, n/12.0f-(4.0f+9.0f/12.0f)) * A4_FREQ;
			n++;
		}
	}
}
static CallCreateDestroy fill_note_to_hz(fillNoteToHz);

//------------------------------------------------------------------------------------------
int HzToNote(char* out_txt, float freq)
{
	float log_freq = logf(freq);

	// don't print freqs below c0
	if(log_freq < log_c0_hz) return sprintf(out_txt, "-"); 

	float note = 12.0f*(log_freq-log_c0_hz)/log_2;
	int close = (int)(note+0.5f);
	int cents = (int)((note-close)*100.0f);
	int octave = close/12;
	int note12 = close-12*octave;
	return sprintf(out_txt, "%s%d:%d", note_names[note12], octave, cents);
}


//------------------------------------------------------------------------------------------
float NoteToHz(const char* txt)
{ 
	string note(txt);
	float cents = 0.0f;
	int colon_pos = note.find(":");
	if(colon_pos != -1) {
		sscanf(&txt[colon_pos+1], "%f", &cents);
		note.resize(colon_pos);
	}
	float& freq = *ptr_find(note_to_hz, note);
	if(!&freq) return -1.0f;
	return freq * powf(2.0f, cents/(12.0f*100.0f));
}
